/**
  ******************************************************************************
  * @file           : main.h
  * @brief          : Header for main.c file.
  *                   This file contains the common defines of the application.
  ******************************************************************************
  */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __MAIN_H__
#define __MAIN_H__

/* Includes ------------------------------------------------------------------*/

/* USER CODE BEGIN Includes */
#include "ht32.h"
/* USER CODE END Includes */

typedef enum
{
  HAL_OK       = 0x00U,
  HAL_ERROR    = 0x01U,
  HAL_BUSY     = 0x02U,
  HAL_TIMEOUT  = 0x03U
} StatusTypeDef;

/* Private define ------------------------------------------------------------*/

#define BC45_IRQ_GPIO_ID 			GPIO_PB
#define BC45_IRQ_GPIO_Port 		HT_GPIOB
#define BC45_IRQ_Pin 					GPIO_PIN_7
#define BC45_IRQ_EXTI_IRQn 		7

#define BC45_RSTPD_GPIO_ID 	  GPIO_PB
#define BC45_RSTPD_GPIO_Port 	HT_GPIOB
#define BC45_RSTPD_Pin 				GPIO_PIN_8

#define LED_GREEN_GPIO_ID 		GPIO_PB
#define LED_GREEN_GPIO_Port 	HT_GPIOB
#define LED_GREEN_Pin 				GPIO_PIN_3
#define LED_RED_GPIO_ID 			GPIO_PB
#define LED_RED_GPIO_Port 		HT_GPIOB
#define LED_RED_Pin 					GPIO_PIN_4
//#define PB3_Pin 							GPIO_PIN_3
//#define PB3_GPIO_Port 				HT_GPIOB
//#define PB4_Pin 							GPIO_PIN_4
//#/define PB4_GPIO_Port 				HT_GPIOB
//#define PB5_Pin 							GPIO_PIN_5
//#define PB5_GPIO_Port 				HT_GPIOB

#define BC45_SPI_CLK(CK)   	(CK.Bit.SPI1)
#define BC45_SPI           	(HT_SPI1)

#define SPI_SCK       			(HT_GPIOA)
#define SPI_SCK_ID       		(GPIO_PA)
#define SPI_SCK_PIN      		(AFIO_PIN_0)
#define SPI_SCK_AFIO_MODE   (AFIO_FUN_SPI)

#define SPI_MOSI      			(HT_GPIOA)
#define SPI_MOSI_ID      		(GPIO_PA)
#define SPI_MOSI_PIN     		(AFIO_PIN_1)
#define SPI_MOSI_AFIO_MODE  (AFIO_FUN_SPI)

#define SPI_MISO      			(HT_GPIOA)
#define SPI_MISO_ID      		(GPIO_PA)
#define SPI_MISO_PIN     		(AFIO_PIN_2)
#define SPI_MISO_AFIO_MODE  (AFIO_FUN_SPI)

#define SPI_SEL       			(HT_GPIOA)
#define SPI_SEL_ID    			(GPIO_PA)
#define SPI_SEL_PIN   			(GPIO_PIN_3)
#define SPI_SEL_AFIO_MODE   (AFIO_MODE_DEFAULT)


#define COM1_CLK(CK)                (CK.Bit.UART1)
#define COM1_PORT                   (HT_UART1)
#define COM1_IRQn                   (UART1_IRQn)
#define COM1_IRQHandler             (UART1_IRQHandler)

#define COM1_TX_GPIO_ID             (GPIO_PA)
#define COM1_TX_AFIO_PIN            (AFIO_PIN_4)
#define COM1_TX_AFIO_MODE           (AFIO_FUN_USART_UART)

#define COM1_RX_GPIO_ID             (GPIO_PA)
#define COM1_RX_AFIO_PIN            (AFIO_PIN_5)
#define COM1_RX_AFIO_MODE           (AFIO_FUN_USART_UART)

/* ########################## Assert Selection ############################## */
/**
  * @brief Uncomment the line below to expanse the "assert_param" macro in the 
  *        HAL drivers code
  */
/* #define USE_FULL_ASSERT    1U */

/* USER CODE BEGIN Private defines */
#define CONFIG_14443A   0x3A
#define CONFIG_14443B   0x3B
#define CONFIG_15693    0x93
#define INV_16_SLOTS    0x16
#define INV_1_SLOT		0x01
#define ISO15693_Speed  0x11

/*RF field definition*/
#define RFON 		0x01
#define	RFOFF  		0x02
#define	RFRESET  	0x03

/* Definition of using LED */
#define LED_RED_ON()			GPIO_ClearOutBits(LED_RED_GPIO_Port, LED_RED_Pin)
#define LED_RED_OFF()		GPIO_SetOutBits(LED_RED_GPIO_Port, LED_RED_Pin)
#define LED_GREEN_ON()		GPIO_ClearOutBits(LED_GREEN_GPIO_Port, LED_GREEN_Pin)
#define LED_GREEN_OFF()	GPIO_SetOutBits(LED_GREEN_GPIO_Port, LED_GREEN_Pin)

void GPIO_EXTI_Callback(uint16_t GPIO_Pin);

/* Function prototype in main.c */
void GotoSleepMode(void);
void GotoStopMode(void);

/* USER CODE END Private defines */

#endif /* __MAIN_H__ */

